/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.LowProfileButtonWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.TooltipButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.YACLSelectionList;
import dev.isxander.yacl3.gui.utils.WidgetUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.mixin.AbstractSelectionListAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8028;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionListWidget
extends YACLSelectionList<Entry> {
    private final YACLScreen yaclScreen;
    private final ConfigCategory category;
    private String searchQuery = "";
    private final Consumer<DescriptionWithName> hoverEvent;
    private DescriptionWithName lastHoveredOption;

    public OptionListWidget(YACLScreen screen, ConfigCategory category, class_310 client, int x, int y, int width, int height, Consumer<DescriptionWithName> hoverEvent) {
        super(client, width, height, y);
        this.yaclScreen = screen;
        this.category = category;
        this.hoverEvent = hoverEvent;
        this.refreshOptions();
        for (OptionGroup group : category.groups()) {
            if (!(group instanceof ListOption)) continue;
            ListOption listOption = (ListOption)group;
            listOption.addRefreshListener(() -> this.refreshListEntries(listOption, category));
        }
    }

    public void refreshOptions() {
        this.method_25339();
        for (OptionGroup group : this.category.groups()) {
            GroupSeparatorEntry groupSeparatorEntry;
            if (!group.isRoot()) {
                GroupSeparatorEntry groupSeparatorEntry2;
                if (group instanceof ListOption) {
                    ListOption listOption = (ListOption)group;
                    groupSeparatorEntry2 = new ListGroupSeparatorEntry(this, listOption, this.yaclScreen);
                } else {
                    groupSeparatorEntry2 = new GroupSeparatorEntry(group, this.yaclScreen);
                }
                groupSeparatorEntry = groupSeparatorEntry2;
                this.addEntry(groupSeparatorEntry);
            } else {
                groupSeparatorEntry = null;
            }
            ArrayList<Entry> optionEntries = new ArrayList<Entry>();
            if (groupSeparatorEntry instanceof ListGroupSeparatorEntry) {
                ListGroupSeparatorEntry listGroupSeparatorEntry = (ListGroupSeparatorEntry)groupSeparatorEntry;
                if (listGroupSeparatorEntry.listOption.options().isEmpty()) {
                    EmptyListLabel emptyListLabel = new EmptyListLabel(this, listGroupSeparatorEntry, this.category);
                    this.addEntry(emptyListLabel);
                    optionEntries.add(emptyListLabel);
                }
            }
            for (Option option : group.options()) {
                OptionEntry entry = new OptionEntry(option, this.category, group, groupSeparatorEntry, option.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
                this.addEntry(entry);
                optionEntries.add(entry);
            }
            if (groupSeparatorEntry == null) continue;
            groupSeparatorEntry.setChildEntries(optionEntries);
        }
        this.method_44382(0.0);
        this.repositionEntries();
    }

    protected int addEntry(Entry entry) {
        return this.method_73370((class_350.class_351)entry, entry.method_25364());
    }

    private void refreshListEntries(ListOption<?> listOption, ConfigCategory category) {
        ListGroupSeparatorEntry groupSeparator = this.method_25396().stream().filter(e -> {
            if (!(e instanceof ListGroupSeparatorEntry)) return false;
            ListGroupSeparatorEntry gs = (ListGroupSeparatorEntry)((Object)e);
            if (gs.group != listOption) return false;
            return true;
        }).map(ListGroupSeparatorEntry.class::cast).findAny().orElse(null);
        if (groupSeparator == null) {
            YACLConstants.LOGGER.warn("Can't find group seperator to refresh list option entries for list option " + String.valueOf(listOption.name()));
            return;
        }
        for (Entry entry : groupSeparator.childEntries) {
            this.method_25330((class_350.class_351)entry);
        }
        groupSeparator.childEntries.clear();
        if (listOption.options().isEmpty()) {
            EmptyListLabel emptyListLabel = new EmptyListLabel(this, groupSeparator, category);
            this.addEntryBelow(groupSeparator, emptyListLabel);
            groupSeparator.childEntries.add(emptyListLabel);
            return;
        }
        Entry lastEntry = groupSeparator;
        for (ListOptionEntry listOptionEntry : listOption.options()) {
            OptionEntry optionEntry = new OptionEntry(listOptionEntry, category, listOption, groupSeparator, listOptionEntry.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
            this.addEntryBelow(lastEntry, optionEntry);
            groupSeparator.childEntries.add(optionEntry);
            lastEntry = optionEntry;
        }
    }

    public Dimension<Integer> getDefaultEntryDimension() {
        return Dimension.ofInt(this.method_25342(), 0, this.method_25322(), 20);
    }

    public void expandAllGroups() {
        for (Entry entry : super.method_25396()) {
            if (!(entry instanceof GroupSeparatorEntry)) continue;
            GroupSeparatorEntry groupSeparatorEntry = (GroupSeparatorEntry)entry;
            groupSeparatorEntry.setExpanded(true);
        }
    }

    public int method_25342() {
        return super.method_25342() - 6;
    }

    public int method_25322() {
        return this.method_25368() - 6 - 20;
    }

    public void updateSearchQuery(String query) {
        this.searchQuery = query;
        for (Entry entry : this.method_25396()) {
            entry.updateSearchQuery(query);
        }
        this.expandAllGroups();
        this.repositionEntries();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (Entry child : this.method_25396()) {
            if (child == this.method_25308(mouseX, mouseY) || !(child instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)child;
            optionEntry.widget.unfocus();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        Entry child;
        super.method_25401(mouseX, mouseY, horizontal, vertical);
        Iterator iterator = this.method_25396().iterator();
        while (iterator.hasNext() && !(child = (Entry)((Object)iterator.next())).method_25401(mouseX, mouseY, horizontal, vertical)) {
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.method_25336() != null && this.method_25397() && this.isValidMouseClick(button)) {
            return WidgetUtils.mouseDragged((class_364)this.method_25336(), mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Entry child : this.method_25396()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        for (Entry child : this.method_25396()) {
            if (!child.charTyped(chr, modifiers)) continue;
            return true;
        }
        return super.charTyped(chr, modifiers);
    }

    private List<Entry> superModifiableChildren() {
        return ((AbstractSelectionListAccessor)((Object)this)).getChildren();
    }

    public void addEntryAtIndex(int index, Entry entry) {
        this.superModifiableChildren().add(index, entry);
        this.repositionEntries();
    }

    public void addEntryBelow(Entry below, Entry entry) {
        int idx = this.superModifiableChildren().indexOf((Object)below) + 1;
        if (idx == 0) {
            throw new IllegalStateException("The entry to insert below does not exist!");
        }
        this.addEntryAtIndex(idx, entry);
    }

    public void addEntryBelowWithoutScroll(Entry below, Entry entry) {
        double d = (double)this.method_44395() - this.method_44387();
        this.addEntryBelow(below, entry);
        this.method_44382((double)this.method_44395() - d);
    }

    private void setHoverDescription(DescriptionWithName description) {
        if (description != this.lastHoveredOption) {
            this.lastHoveredOption = description;
            this.hoverEvent.accept(description);
        }
    }

    protected void method_57715(class_332 guiGraphics) {
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0 || button == 1 || button == 2;
    }

    protected Entry nextEntry(@NotNull class_8028 direction, @NotNull Predicate<Entry> predicate, Entry selected) {
        return (Entry)super.method_48199(direction, entry -> entry.isViewable() && predicate.test((Entry)((Object)entry)), (class_350.class_351)selected);
    }

    public class ListGroupSeparatorEntry
    extends GroupSeparatorEntry {
        private final ListOption<?> listOption;
        private final TextScaledButtonWidget resetListButton;
        private final TooltipButtonWidget addListButton;

        private ListGroupSeparatorEntry(OptionListWidget this$0, ListOption<?> group, class_437 screen) {
            super(group, screen);
            this.listOption = group;
            this.resetListButton = new TextScaledButtonWidget(screen, this$0.method_31383() - 20, -50, 20, 20, 1.0f, (class_2561)class_2561.method_43470((String)"\u21bb"), button -> group.requestSetDefault());
            group.addListener((opt, val) -> {
                this.resetListButton.field_22763 = !opt.isPendingValueDefault() && opt.available();
            });
            this.resetListButton.field_22763 = !group.isPendingValueDefault() && group.available();
            this.addListButton = new TooltipButtonWidget(this$0.yaclScreen, this.resetListButton.method_46426() - 20, -50, 20, 20, (class_2561)class_2561.method_43470((String)"+"), (class_2561)class_2561.method_43471((String)"yacl.list.add_top"), btn -> {
                group.insertNewEntry();
                this.setExpanded(true);
            });
            this.updateExpandMinimizeText();
            this.minimizeIfUnavailable();
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (!this.isViewable()) {
                return;
            }
            this.updateExpandMinimizeText();
            super.method_25343(graphics, mouseX, mouseY, hovered, deltaTicks);
            int buttonY = this.expandMinimizeButton.method_46427();
            this.resetListButton.method_46419(buttonY);
            this.addListButton.method_46419(buttonY);
            this.resetListButton.method_25394(graphics, mouseX, mouseY, deltaTicks);
            this.addListButton.method_25394(graphics, mouseX, mouseY, deltaTicks);
        }

        private void minimizeIfUnavailable() {
            if (!this.listOption.available() && this.isExpanded()) {
                this.setExpanded(false);
            }
        }

        @Override
        protected void updateExpandMinimizeText() {
            super.updateExpandMinimizeText();
            boolean bl = this.expandMinimizeButton.field_22763 = this.listOption == null || this.listOption.available();
            if (this.addListButton != null) {
                this.addListButton.field_22763 = this.expandMinimizeButton.field_22763 && this.listOption.numberOfEntries() < this.listOption.maximumNumberOfEntries();
            }
        }

        @Override
        public void setExpanded(boolean expanded) {
            super.setExpanded(this.listOption.available() && expanded);
        }

        @Override
        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton), (Object)((Object)this.addListButton), (Object)((Object)this.resetListButton));
        }
    }

    public class GroupSeparatorEntry
    extends Entry {
        protected final OptionGroup group;
        protected final class_5489 wrappedName;
        protected final class_5489 wrappedTooltip;
        protected final LowProfileButtonWidget expandMinimizeButton;
        protected final class_437 screen;
        protected final class_327 font;
        protected boolean groupExpanded;
        protected List<Entry> childEntries;

        private GroupSeparatorEntry(OptionGroup group, class_437 screen) {
            super(OptionListWidget.this);
            this.font = class_310.method_1551().field_1772;
            this.childEntries = new ArrayList<Entry>();
            this.group = group;
            this.screen = screen;
            this.wrappedName = class_5489.method_30890((class_327)this.font, (class_2561)group.name(), (int)(OptionListWidget.this.method_25322() - 45));
            this.wrappedTooltip = class_5489.method_30890((class_327)this.font, (class_2561)group.tooltip(), (int)(screen.field_22789 / 3 * 2 - 10));
            this.groupExpanded = !group.collapsed();
            this.expandMinimizeButton = new LowProfileButtonWidget(0, 0, 20, 20, (class_2561)class_2561.method_43473(), btn -> this.onExpandButtonPress());
            this.updateExpandMinimizeText();
            this.updateHeight();
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (!this.isViewable()) {
                return;
            }
            this.updateHeight();
            int buttonY = this.method_46427() + this.method_25364() / 2 - this.expandMinimizeButton.method_25364() / 2 + 1;
            this.expandMinimizeButton.method_46419(buttonY);
            this.expandMinimizeButton.method_46421(this.method_46426());
            this.expandMinimizeButton.method_25394(graphics, mouseX, mouseY, deltaTicks);
            int n = this.method_46426() + this.method_25368() / 2;
            int n2 = this.method_46427() + this.getYPadding();
            Objects.requireNonNull(this.font);
            this.wrappedName.method_73212(graphics, class_5489.class_11735.field_62010, n, n2, 9, false, -1);
            if (this.method_25405(mouseX, mouseY)) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        public boolean isExpanded() {
            return this.groupExpanded;
        }

        public void setExpanded(boolean expanded) {
            if (this.groupExpanded == expanded) {
                return;
            }
            this.groupExpanded = expanded;
            this.updateExpandMinimizeText();
            this.childEntries.forEach(Entry::refreshVisibilityState);
            OptionListWidget.this.repositionEntries();
        }

        protected void onExpandButtonPress() {
            this.setExpanded(!this.isExpanded());
        }

        protected void updateExpandMinimizeText() {
            this.expandMinimizeButton.method_25355((class_2561)class_2561.method_43470((String)(this.isExpanded() ? "\u25bc" : "\u25b6")));
        }

        public void setChildEntries(List<? extends Entry> childEntries) {
            this.childEntries.clear();
            this.childEntries.addAll(childEntries);
        }

        @Override
        public boolean updateSearchQuery(String searchQuery) {
            this.searchQueryMatches = searchQuery.isEmpty() || this.childEntries.stream().anyMatch(e -> e.updateSearchQuery(searchQuery));
            return this.searchQueryMatches;
        }

        private int getYPadding() {
            return 6;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        private void updateHeight() {
            int n = Math.max(this.wrappedName.method_30887(), 1);
            Objects.requireNonNull(this.font);
            this.method_73383(n * 9 + this.getYPadding() * 2);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                @NotNull
                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, GroupSeparatorEntry.this.group.name());
                    builder.method_37034(class_6381.field_33790, GroupSeparatorEntry.this.group.tooltip());
                }
            });
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton));
        }
    }

    public abstract class Entry
    extends YACLSelectionList.Entry<Entry> {
        protected boolean searchQueryMatches = true;

        public Entry(OptionListWidget this$0) {
            super(this$0);
        }

        public boolean updateSearchQuery(String searchQuery) {
            boolean matches = searchQuery.isEmpty();
            if (this.searchQueryMatches != matches) {
                this.searchQueryMatches = matches;
                this.refreshVisibilityState();
            }
            return this.searchQueryMatches;
        }

        public boolean isViewable() {
            return this.searchQueryMatches;
        }

        public int method_25364() {
            if (!this.isViewable()) {
                return 0;
            }
            return super.method_25364();
        }

        protected void refreshVisibilityState() {
            if (this.isViewable()) {
                this.onBecameViewable();
            } else {
                this.onBecameHidden();
            }
        }

        protected void onBecameViewable() {
        }

        protected void onBecameHidden() {
            this.method_73383(0);
        }
    }

    public class EmptyListLabel
    extends Entry {
        private final ListGroupSeparatorEntry parent;
        private final String groupName;
        private final String categoryName;

        public EmptyListLabel(OptionListWidget this$0, ListGroupSeparatorEntry parent, ConfigCategory category) {
            super(this$0);
            this.parent = parent;
            this.groupName = parent.group.name().getString().toLowerCase();
            this.categoryName = category.name().getString().toLowerCase();
            this.method_73383(11);
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"yacl.list.empty").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}), this.method_46426() + this.method_25368() / 2, this.method_46427(), -1);
        }

        @Override
        public boolean updateSearchQuery(String searchQuery) {
            this.searchQueryMatches = searchQuery.isEmpty() || this.groupName.contains(searchQuery);
            return this.searchQueryMatches;
        }

        @Override
        public boolean isViewable() {
            return this.parent.isExpanded() && super.isViewable();
        }

        @Override
        protected void onBecameHidden() {
            super.onBecameHidden();
            this.method_73383(0);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of();
        }
    }

    public class OptionEntry
    extends Entry {
        public final Option<?> option;
        public final ConfigCategory category;
        public final OptionGroup group;
        @Nullable
        public final GroupSeparatorEntry groupSeparatorEntry;
        public final AbstractWidget widget;
        private final TextScaledButtonWidget resetButton;
        private final String categoryName;
        private final String groupName;

        public OptionEntry(Option<?> option, ConfigCategory category, @Nullable OptionGroup group, GroupSeparatorEntry groupSeparatorEntry, AbstractWidget widget) {
            super(OptionListWidget.this);
            this.option = option;
            this.category = category;
            this.group = group;
            this.groupSeparatorEntry = groupSeparatorEntry;
            this.widget = widget;
            this.categoryName = category.name().getString().toLowerCase();
            this.groupName = group.name().getString().toLowerCase();
            if (option.canResetToDefault() && this.widget.canReset()) {
                this.widget.setDimension(this.widget.getDimension().expanded(-20, 0));
                this.resetButton = new TextScaledButtonWidget((class_437)OptionListWidget.this.yaclScreen, (int)widget.getDimension().xLimit(), -50, 20, 20, 2.0f, (class_2561)class_2561.method_43470((String)"\u21bb"), button -> option.requestSetDefault());
                option.addListener((opt, val) -> {
                    this.resetButton.field_22763 = !opt.isPendingValueDefault() && opt.available();
                });
                this.resetButton.field_22763 = !option.isPendingValueDefault() && option.available();
            } else {
                this.resetButton = null;
            }
            this.updateHeight();
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (!this.isViewable()) {
                return;
            }
            this.updateHeight();
            this.widget.setDimension(this.widget.getDimension().withY(this.method_46427()));
            this.widget.method_25394(graphics, mouseX, mouseY, deltaTicks);
            if (this.resetButton != null) {
                this.resetButton.method_46419(this.method_46427());
                this.resetButton.method_25394(graphics, mouseX, mouseY, deltaTicks);
            }
            if (this.method_25405(mouseX, mouseY)) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
            return this.widget.method_25401(mouseX, mouseY, horizontal, vertical);
        }

        @Override
        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return WidgetUtils.keyPressed(this.widget, keyCode, scanCode, modifiers);
        }

        @Override
        public boolean charTyped(char chr, int modifiers) {
            return WidgetUtils.charTyped(this.widget, chr, modifiers);
        }

        @Override
        public boolean updateSearchQuery(String searchQuery) {
            this.searchQueryMatches = searchQuery.isEmpty() || this.groupName.contains(searchQuery) || this.widget.matchesSearch(searchQuery);
            this.refreshVisibilityState();
            return this.searchQueryMatches;
        }

        @Override
        public boolean isViewable() {
            return super.isViewable() && (this.groupSeparatorEntry == null || this.groupSeparatorEntry.isExpanded());
        }

        @Override
        protected void onBecameViewable() {
            super.onBecameViewable();
            this.updateHeight();
        }

        private void updateHeight() {
            this.method_73383(Math.max(this.widget.getDimension().height(), this.resetButton != null ? this.resetButton.method_25364() : 0) + 2);
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public List<? extends class_6379> method_37025() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }

        public List<? extends class_364> method_25396() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }
    }
}

