/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1534;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.TraceableException;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeLanguages;
import snownee.jade.util.KeyedResourceManagerReloadListener;
import snownee.jade.util.WordCutter;

public class ModIdentification
implements KeyedResourceManagerReloadListener {
    public static final class_2960 ID = JadeIds.JADE("mod_id");
    public static final ModIdentification INSTANCE = new ModIdentification();
    public static int NAME_MAX_WIDTH = 160;
    private static final Map<String, Optional<String>> NAMES = Maps.newConcurrentMap();
    private static final Map<String, Optional<String>> CUT_NAMES = Maps.newConcurrentMap();
    @Nullable
    private static WordCutter wordCutter;
    public static final String JADE_STACK = "$jade:stack";
    public static final MapCodec<class_2960> JADE_STACK_ID_CODEC;
    public static final String POLYMER_STACK = "$polymer:stack";
    public static final MapCodec<class_2960> POLYMER_STACK_ID_CODEC;

    public static WordCutter wordCutter() {
        WordCutter cutter = wordCutter;
        if (cutter == null) {
            JadeLanguages languages = JadeLanguages.INSTANCE;
            BreakIterator iterator = BreakIterator.getWordInstance(languages.getLocale());
            wordCutter = cutter = new WordCutter(iterator, languages);
        }
        return cutter;
    }

    public static void invalidateCache() {
        NAMES.clear();
        CUT_NAMES.clear();
        wordCutter = null;
    }

    public static String cutName(String fullName, int maxWidth) {
        WordCutter.Token last;
        int start;
        int tokens;
        fullName = fullName.trim();
        if (maxWidth <= 0) {
            return fullName;
        }
        if (DisplayHelper.font().method_1727(fullName) <= maxWidth) {
            return fullName;
        }
        WordCutter cutter = ModIdentification.wordCutter();
        cutter.setText(fullName, maxWidth);
        do {
            tokens = cutter.tokenCount();
            cutter.removeBracketed();
            cutter.trim();
        } while (tokens != cutter.tokenCount() && cutter.tooLong());
        if (cutter.hasColon() && cutter.tooLong() && (start = cutter.findFirst((Predicate<WordCutter.Token>)((Predicate)token -> token.type() == WordCutter.TokenType.COLON))) != -1) {
            boolean remove;
            String s = cutter.concat(start + 1, cutter.tokenCount()).trim().toLowerCase(Locale.ENGLISH);
            boolean bl = remove = s.endsWith("edition") || s.endsWith("version");
            if (!remove && !s.contains(" ")) {
                boolean bl2 = remove = s.equals("legacy") || s.startsWith("re");
            }
            if (remove) {
                cutter.removeRange(start, cutter.tokenCount());
                cutter.trim();
            }
        }
        if (cutter.tooLong() && (last = cutter.tokens().getLast()).type() == WordCutter.TokenType.WORD && last.str().toLowerCase(Locale.ENGLISH).equals("mod")) {
            cutter.removeRange(cutter.tokenCount() - 1, cutter.tokenCount());
            cutter.trim();
        }
        cutter.cutToMaxWidth(true);
        return cutter.toString();
    }

    public static Optional<String> getModName(String namespace) {
        return ModIdentification.getModName(namespace, NAME_MAX_WIDTH);
    }

    public static Optional<String> getModName(String namespace, int maxWidth) {
        if (maxWidth != NAME_MAX_WIDTH) {
            return ModIdentification.getModNameInternal(namespace, maxWidth);
        }
        return CUT_NAMES.computeIfAbsent(namespace, $ -> ModIdentification.getModNameInternal($, NAME_MAX_WIDTH));
    }

    public static Optional<String> getModNameInternal(String namespace, int maxWidth) {
        String fullName = ModIdentification.getModFullName(namespace).orElse(null);
        if (fullName == null) {
            return Optional.empty();
        }
        return Optional.of(ModIdentification.cutName(fullName, maxWidth));
    }

    public static Optional<String> getModFullName(String namespace) {
        return NAMES.computeIfAbsent(namespace, $ -> {
            String key = "jade.modName." + $;
            if (class_1074.method_4663((String)key)) {
                return Optional.of(class_1074.method_4662((String)key, (Object[])new Object[0]));
            }
            key = "itemGroup." + $;
            if (class_1074.method_4663((String)key)) {
                return Optional.of(class_1074.method_4662((String)key, (Object[])new Object[0]));
            }
            return ClientProxy.getModName($).map(class_124::method_539);
        });
    }

    public static String getModName(class_2960 id) {
        return ModIdentification.getModName(id.method_12836()).orElse(id.method_12836());
    }

    public static String getModName(class_2248 block) {
        class_2960 id;
        try {
            id = CommonProxy.getId(block);
        }
        catch (Throwable e) {
            throw TraceableException.create(e, class_7923.field_41175.method_10221((Object)block).method_12836());
        }
        return ModIdentification.getModName(id);
    }

    public static Optional<class_2960> getSpecialId(class_1799 stack) {
        class_9279 data = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        if (!class_9279.field_49302.equals((Object)data)) {
            if (data.field_49306.method_10545(JADE_STACK)) {
                return data.field_49306.method_67487(JADE_STACK_ID_CODEC);
            }
            if (data.field_49306.method_10545(POLYMER_STACK)) {
                return data.field_49306.method_67487(POLYMER_STACK_ID_CODEC);
            }
        }
        return Optional.empty();
    }

    public static String getModId(class_1799 stack) {
        Optional<class_2960> specialId = ModIdentification.getSpecialId(stack);
        if (specialId.isPresent()) {
            return specialId.orElseThrow().method_12836();
        }
        return CommonProxy.getModIdFromItem(stack);
    }

    public static String getModName(class_1799 stack) {
        String id;
        try {
            for (JadeItemModNameCallback callback : WailaClientRegistration.instance().itemModNameCallback.callbacks()) {
                String s = callback.gatherItemModName(stack);
                if (Strings.isNullOrEmpty((String)s)) continue;
                return s;
            }
            id = ModIdentification.getModId(stack);
        }
        catch (Throwable e) {
            throw TraceableException.create(e, class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836());
        }
        return ModIdentification.getModName(id).orElse(id);
    }

    public static String getModName(class_1297 entity) {
        class_2960 id;
        if (entity instanceof class_1534) {
            class_1534 painting = (class_1534)entity;
            return ModIdentification.getModName(((class_5321)painting.method_43404().method_40230().orElseThrow()).method_29177());
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return ModIdentification.getModName(itemEntity.method_6983());
        }
        if (entity instanceof class_1540) {
            class_1540 fallingBlock = (class_1540)entity;
            return ModIdentification.getModName(fallingBlock.method_6962().method_26204());
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            return ModIdentification.getModName(((class_5321)villager.method_7231().comp_3521().method_40230().orElseThrow()).method_29177());
        }
        try {
            id = CommonProxy.getId(entity.method_5864());
        }
        catch (Throwable e) {
            throw TraceableException.create(e, class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836());
        }
        return ModIdentification.getModName(id);
    }

    public void method_14491(class_3300 manager) {
        ModIdentification.invalidateCache();
    }

    @Override
    public class_2960 getUid() {
        return ID;
    }

    static {
        JADE_STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").fieldOf(JADE_STACK);
        POLYMER_STACK_ID_CODEC = class_2960.field_25139.fieldOf("id").fieldOf(POLYMER_STACK);
    }
}

