/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.Element;

public interface AccessorClientHandler<T extends Accessor<?>> {
    public boolean shouldDisplay(T var1);

    public List<IServerDataProvider<T>> shouldRequestData(T var1);

    public void requestData(T var1, List<IServerDataProvider<T>> var2);

    @Nullable
    public Element getIcon(T var1);

    public void gatherComponents(T var1, Function<IJadeProvider, ITooltip> var2);

    default public boolean isEnabled(IToggleableProvider provider) {
        if (!IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && JadeIds.isAccess(provider.getUid())) {
            return false;
        }
        return IWailaConfig.get().plugin().get(provider);
    }
}

