/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.math2d.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000eJ8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b \u0010\u000eR\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u0011\u0010$\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b&\u0010%R\u0011\u0010'\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0011\u0010)\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\u0011\u0010+\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0011\u0010-\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0011\u0010/\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000e\u00a8\u00060"}, d2={"Lorg/anti_ad/mc/common/math2d/Line;", "", "", "startX", "startY", "endX", "endY", "<init>", "(IIII)V", "Lorg/anti_ad/mc/common/math2d/Point;", "start", "end", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Point;)V", "component1", "()I", "component2", "component3", "component4", "copy", "(IIII)Lorg/anti_ad/mc/common/math2d/Line;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getStartX", "getStartY", "getEndX", "getEndY", "getStart", "()Lorg/anti_ad/mc/common/math2d/Point;", "getEnd", "isPoint", "()Z", "isHorizontal", "isVertical", "getMinX", "minX", "getMaxX", "maxX", "getMinY", "minY", "getMaxY", "maxY", "fabric-1.21.10"})
public final class Line {
    private final int startX;
    private final int startY;
    private final int endX;
    private final int endY;

    public Line(int startX, int startY, int endX, int endY) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
    }

    public final int getStartX() {
        return this.startX;
    }

    public final int getStartY() {
        return this.startY;
    }

    public final int getEndX() {
        return this.endX;
    }

    public final int getEndY() {
        return this.endY;
    }

    public Line(@NotNull Point start, @NotNull Point end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    @NotNull
    public final Point getStart() {
        return new Point(this.startX, this.startY);
    }

    @NotNull
    public final Point getEnd() {
        return new Point(this.endX, this.endY);
    }

    public final boolean isPoint() {
        return Intrinsics.areEqual((Object)this.getStart(), (Object)this.getEnd());
    }

    public final boolean isHorizontal() {
        return this.startY == this.endY;
    }

    public final boolean isVertical() {
        return this.startX == this.endX;
    }

    public final int getMinX() {
        return Math.min(this.startX, this.endX);
    }

    public final int getMaxX() {
        return Math.max(this.startX, this.endX);
    }

    public final int getMinY() {
        return Math.min(this.startY, this.endY);
    }

    public final int getMaxY() {
        return Math.max(this.startY, this.endY);
    }

    public final int component1() {
        return this.startX;
    }

    public final int component2() {
        return this.startY;
    }

    public final int component3() {
        return this.endX;
    }

    public final int component4() {
        return this.endY;
    }

    @NotNull
    public final Line copy(int startX, int startY, int endX, int endY) {
        return new Line(startX, startY, endX, endY);
    }

    public static /* synthetic */ Line copy$default(Line line, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = line.startX;
        }
        if ((n5 & 2) != 0) {
            n2 = line.startY;
        }
        if ((n5 & 4) != 0) {
            n3 = line.endX;
        }
        if ((n5 & 8) != 0) {
            n4 = line.endY;
        }
        return line.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "Line(startX=" + this.startX + ", startY=" + this.startY + ", endX=" + this.endX + ", endY=" + this.endY + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.startX);
        result = result * 31 + Integer.hashCode(this.startY);
        result = result * 31 + Integer.hashCode(this.endX);
        result = result * 31 + Integer.hashCode(this.endY);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line)) {
            return false;
        }
        Line line = (Line)other;
        if (this.startX != line.startX) {
            return false;
        }
        if (this.startY != line.startY) {
            return false;
        }
        if (this.endX != line.endX) {
            return false;
        }
        return this.endY == line.endY;
    }
}

