/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.integration;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.common.TellPlayer;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.anti_ad.mc.ipn.api.IPNSlotsIgnoreForInventoryTypes;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.integration.ButtonPositionHint;
import org.anti_ad.mc.ipnext.integration.HintClassData;
import org.anti_ad.mc.ipnext.integration.MergePriority;
import org.anti_ad.mc.ipnext.integration.MiscKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nHintsManagerNG.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HintsManagerNG.kt\norg/anti_ad/mc/ipnext/integration/HintsManagerNG\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Misc.kt\norg/anti_ad/mc/ipnext/integration/MiscKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,336:1\n80#2:337\n80#2:350\n42#2:369\n42#2:394\n33#3:338\n89#3,4:339\n34#3:343\n33#3:351\n89#3,4:352\n34#3:356\n33#3:373\n89#3,4:374\n34#3:378\n33#3:379\n89#3,4:380\n34#3:384\n216#4,2:344\n216#4,2:346\n216#4:357\n216#4:358\n217#4:360\n217#4:361\n216#4,2:364\n216#4,2:366\n216#4:368\n217#4:370\n216#4,2:392\n216#4,2:397\n41#5,2:348\n43#5,2:362\n41#5,2:395\n43#5,2:399\n1#6:359\n13472#7,2:371\n504#8,7:385\n*S KotlinDebug\n*F\n+ 1 HintsManagerNG.kt\norg/anti_ad/mc/ipnext/integration/HintsManagerNG\n*L\n76#1:337\n132#1:350\n181#1:369\n322#1:394\n77#1:338\n77#1:339,4\n77#1:343\n134#1:351\n134#1:352,4\n134#1:356\n269#1:373\n269#1:374,4\n269#1:378\n276#1:379\n276#1:380,4\n276#1:384\n117#1:344,2\n121#1:346,2\n136#1:357\n137#1:358\n137#1:360\n136#1:361\n160#1:364,2\n165#1:366,2\n176#1:368\n176#1:370\n291#1:392,2\n97#1:397,2\n131#1:348,2\n131#1:362,2\n95#1:395,2\n95#1:399,2\n209#1:371,2\n289#1:385,7\n*E\n"})
public final class HintsManagerNG {
    @NotNull
    public static final HintsManagerNG INSTANCE = new HintsManagerNG();
    @NotNull
    private static final String exampleFileName = "exampleIntegrationHints.json";
    @NotNull
    private static final String builtInHintsResource = "assets/inventoryprofilesnext/config/ModIntegrationHintsNG.json";
    @NotNull
    private static final String hintsExport = "ModIntegrationExport.json";
    @NotNull
    private static final String exampleHintsResource = "assets/inventoryprofilesnext/config/exampleIntegrationHints.json";
    @NotNull
    private static final String integratedOverride = "ModIntegrationOverride.json";
    private static Path externalHintsPath;
    private static Path configRoot;
    @NotNull
    private static final Map externalConfigs;
    @NotNull
    private static final Map internalConfigs;
    @NotNull
    private static final Map effectiveHints;

    private HintsManagerNG() {
    }

    private final Map processConfig(InputStream inputStream) {
        Json json = MiscKt.getJson();
        json.getSerializersModule();
        Object object = JvmStreamsKt.decodeFromStream((Json)json, (DeserializationStrategy)((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, HintClassData.Companion.serializer())), (InputStream)inputStream);
        Map cfr_ignored_0 = (Map)object;
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {}
        return (Map)object;
    }

    public final void init(@NotNull Path path, @NotNull Path path2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"");
        this.reset();
        configRoot = path;
        externalHintsPath = path2;
        this.doInit(bl);
    }

    private final void doInit(boolean bl) {
        Object object;
        block16: {
            Iterator iterator;
            block17: {
                Path path;
                LinkOption[] object2;
                FileVisitOption[] fileVisitOptionArray = externalHintsPath;
                if (externalHintsPath == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"");
                    fileVisitOptionArray = null;
                }
                if (Files.isDirectory((Path)(object = fileVisitOptionArray), Arrays.copyOf(object2 = new LinkOption[0], object2.length))) {
                    Path path2 = externalHintsPath;
                    if (path2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"");
                        path2 = null;
                    }
                    FileVisitOption[] fileVisitOptionArray2 = new FileVisitOption[1];
                    object = fileVisitOptionArray2;
                    fileVisitOptionArray2[0] = FileVisitOption.FOLLOW_LINKS;
                    Files.find(path2, 1, HintsManagerNG::doInit$lambda$2, object).forEach(arg_0 -> HintsManagerNG.doInit$lambda$7(arg_0 -> HintsManagerNG.doInit$lambda$6(bl, arg_0), arg_0));
                }
                if ((path = configRoot) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"");
                    path = null;
                }
                if (!Java_ioKt.exists((Path)(object = Java_ioKt.div((Path)path, (String)integratedOverride)))) break block17;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"");
                Closeable throwable4 = inputStream;
                object = null;
                try {
                    iterator = (InputStream)throwable4;
                    INSTANCE.readInternalConfig((InputStream)((Object)iterator), bl);
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        object = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)throwable4, (Throwable)object);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)throwable4, null);
                break block16;
            }
            InputStream inputStream = HintsManagerNG.class.getClassLoader().getResourceAsStream(builtInHintsResource);
            if (inputStream != null) {
                object = inputStream;
                iterator = null;
                try {
                    InputStream inputStream2 = (InputStream)object;
                    INSTANCE.readInternalConfig(inputStream2, bl);
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable4 = throwable;
                        iterator = throwable;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)((Object)iterator));
                        throw throwable5;
                    }
                }
                CloseableKt.closeFinally((Closeable)object, null);
            }
        }
        Log.INSTANCE.info("Loaded " + externalConfigs.size() + " external GUI hints");
        for (Map.Entry entry : externalConfigs.entrySet()) {
            object = (String)entry.getKey();
            HintClassData hintClassData = (HintClassData)entry.getValue();
            effectiveHints.putIfAbsent(object, hintClassData);
        }
        Log.INSTANCE.info("Loaded " + internalConfigs.size() + " build-in GUI hints");
        for (Map.Entry entry : internalConfigs.entrySet()) {
            object = (String)entry.getKey();
            HintClassData hintClassData = (HintClassData)entry.getValue();
            effectiveHints.putIfAbsent(object, hintClassData);
        }
        if (bl) {
            TellPlayer.INSTANCE.chat("Found " + effectiveHints.size() + " hints. " + internalConfigs.size() + " internal and " + externalConfigs.size() + " external");
        }
        Log.INSTANCE.info("Effective GUI hints after merge: " + effectiveHints.size());
    }

    /*
     * WARNING - void declaration
     */
    private final void readInternalConfig(InputStream object2, boolean bl) {
        String string = "";
        try {
            Json json = MiscKt.getJson();
            json.getSerializersModule();
            Iterator iterator = JvmStreamsKt.decodeFromStream((Json)json, (DeserializationStrategy)((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, HintClassData.Companion.serializer()))), (InputStream)object2);
            Map cfr_ignored_0 = (Map)((Object)iterator);
            try {
                ((InputStream)object2).close();
            }
            catch (Throwable throwable) {}
            for (Map.Entry entry : ((Map)((Object)iterator)).entrySet()) {
                iterator = ((Map)entry.getValue()).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    Map map = internalConfigs;
                    Object k2 = entry2.getKey();
                    entry2 = entry2.getValue();
                    ((HintClassData)((Object)entry2)).changeId((String)entry.getKey());
                    map.put(k2, entry2);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            void var2_4;
            MiscKt.logError(throwable, string, (boolean)var2_4);
            return;
        }
    }

    public final void saveAllAsIntegrated(@NotNull MergePriority object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = MapsKt.toSortedMap((Map)this.collectAllWithPriority((MergePriority)((Object)object)));
        Path path = configRoot;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            path = null;
        }
        Object object2 = Java_ioKt.div((Path)path, (String)hintsExport);
        Files.deleteIfExists((Path)object2);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"");
        object2 = outputStream;
        JvmStreamsKt.encodeToStream((Json)MiscKt.getJson(), (SerializationStrategy)((SerializationStrategy)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)HintClassData.Companion.serializer()))), (Object)object, (OutputStream)object2);
        ((OutputStream)object2).close();
    }

    private final Map collectAllWithPriority(MergePriority object) {
        String string;
        Iterator iterator = object == MergePriority.EXTERNAL ? externalConfigs : internalConfigs;
        object = object == MergePriority.EXTERNAL ? internalConfigs : externalConfigs;
        Map map = new LinkedHashMap();
        Set set = new LinkedHashSet();
        for (Map.Entry entry : iterator.entrySet()) {
            string = (String)entry.getKey();
            HintClassData object2 = (HintClassData)entry.getValue();
            String string2 = object2.readId();
            Intrinsics.checkNotNull((Object)string2);
            Map map2 = map.putIfAbsent(string2, (Map)new LinkedHashMap());
            if (map2 == null) {
                String string3 = object2.readId();
                Intrinsics.checkNotNull((Object)string3);
                map2 = (Map)map.get(string3);
            }
            Intrinsics.checkNotNull((Object)map2);
            map2.putIfAbsent(string, HintClassData.copy$default(object2, false, false, false, object2.copyOnlyChanged(), null, false, false, false, 247, null));
            set.add(string);
        }
        for (Map.Entry entry : object.entrySet()) {
            string = (String)entry.getKey();
            HintClassData hintClassData = (HintClassData)entry.getValue();
            if (set.contains(string)) continue;
            String string4 = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string4);
            Map map3 = map.putIfAbsent(string4, (Map)new LinkedHashMap());
            if (map3 == null) {
                String string5 = hintClassData.readId();
                Intrinsics.checkNotNull((Object)string5);
                map3 = (Map)map.get(string5);
            }
            Intrinsics.checkNotNull((Object)map3);
            map3.putIfAbsent(string, HintClassData.copy$default(hintClassData, false, false, false, hintClassData.copyOnlyChanged(), null, false, false, false, 247, null));
        }
        return map;
    }

    public final void saveAllAsSeparate(@NotNull MergePriority object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        for (Map.Entry entry : this.collectAllWithPriority((MergePriority)((Object)object)).entrySet()) {
            OutputStream outputStream;
            Object object2 = (String)entry.getKey();
            Map object22 = (Map)entry.getValue();
            Path path = externalHintsPath;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"");
                path = null;
            }
            object2 = Java_ioKt.div((Path)path, (String)((String)object2 + ".json"));
            Files.deleteIfExists((Path)object2);
            OpenOption[] openOptionArray = new OpenOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.newOutputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"");
            TellPlayer.INSTANCE.chat("Generating " + PathsKt.getName((Path)object2));
            Json json = MiscKt.getJson();
            json.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)json, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, HintClassData.Companion.serializer())), (Object)object22, (OutputStream)outputStream);
        }
    }

    @NotNull
    public final HintClassData getHints(@NotNull Class clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        Object object = effectiveHints.get(clazz.getName());
        Object object2 = object != null && !((HintClassData)object).getForce() && (clazz.isAnnotationPresent(IPNIgnore.class) || clazz.isAnnotationPresent(IPNPlayerSideOnly.class) || clazz.isAnnotationPresent(IPNGuiHint.class) || clazz.isAnnotationPresent(IPNSlotsIgnoreForInventoryTypes.class)) ? null : object;
        if (object2 == null) {
            int n2;
            Object[] objectArray;
            Object[] objectArray2;
            object = INSTANCE;
            Object[] objectArray3 = ((HintsManagerNG)object).getIgnoredClass(clazz);
            if (objectArray3 != null) {
                objectArray2 = objectArray3;
                Object[] objectArray4 = objectArray3;
                if (!Intrinsics.areEqual((Object)objectArray3, (Object)clazz)) {
                    ((HintsManagerNG)object).getHints((Class)objectArray4);
                }
                objectArray = objectArray2;
            } else {
                objectArray = null;
            }
            boolean bl = objectArray != null;
            Map map = new LinkedHashMap();
            Annotation[] annotationArray = clazz.getAnnotationsByType(IPNGuiHint.class);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"");
            objectArray2 = annotationArray;
            int n3 = objectArray2.length;
            for (n2 = 0; n2 < n3; n2 += 1) {
                IPNGuiHint iPNGuiHint = (IPNGuiHint)objectArray2[n2];
                Log.INSTANCE.trace("Found @IPNGuiHint for button: " + iPNGuiHint.button().name());
                map.put(iPNGuiHint.button(), new ButtonPositionHint(iPNGuiHint.horizontalOffset(), iPNGuiHint.top(), iPNGuiHint.bottom(), iPNGuiHint.hide()));
            }
            boolean bl2 = clazz.isAnnotationPresent(IPNPlayerSideOnly.class);
            Annotation[] annotationArray2 = clazz.getAnnotationsByType(IPNSlotsIgnoreForInventoryTypes.class);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"");
            Object object3 = (Object[])ArraysKt.firstOrNull((Object[])annotationArray2);
            if (object3 == null || (object3 = object3.value()) == null || (object3 = ArraysKt.toMutableSet((Object[])object3)) == null) {
                object3 = new LinkedHashSet();
            }
            Object object4 = object3;
            Annotation[] annotationArray3 = clazz.getAnnotationsByType(IPNSlotsIgnoreForInventoryTypes.class);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray3, (String)"");
            IPNSlotsIgnoreForInventoryTypes iPNSlotsIgnoreForInventoryTypes = (IPNSlotsIgnoreForInventoryTypes)ArraysKt.firstOrNull((Object[])annotationArray3);
            int n4 = iPNSlotsIgnoreForInventoryTypes != null ? iPNSlotsIgnoreForInventoryTypes.ignoreCraftingSlots() : (n2 = 0);
            HintClassData hintClassData = bl || bl2 || n2 != 0 || !map.isEmpty() || !((Collection)object4).isEmpty() ? new HintClassData(bl, bl2, false, map, (Set)object4, n2 != 0, false, false, 192, null) : new HintClassData(false, false, false, null, null, false, false, false, 255, null);
            hintClassData.fillMissingHints();
            object4 = hintClassData;
            effectiveHints.put(clazz.getName(), object4);
            object2 = object4;
        }
        return object2;
    }

    private final Class getIgnoredClass(Class clazz) {
        while (!Intrinsics.areEqual((Object)clazz, Object.class)) {
            if (clazz.isAnnotationPresent(IPNIgnore.class)) {
                return clazz;
            }
            Intrinsics.checkNotNullExpressionValue(clazz.getSuperclass(), (String)"");
        }
        return null;
    }

    private final void reset() {
        externalConfigs.clear();
        internalConfigs.clear();
        effectiveHints.clear();
    }

    public final boolean isPlayerSideOnly(@Nullable Class clazz) {
        return clazz != null && this.getHints(clazz).getPlayerSideOnly();
    }

    public final boolean isFastSwipeDisabled(@Nullable Class clazz) {
        return clazz != null && this.getHints(clazz).getDisableFastSwipe();
    }

    public final void upgradeOldConfig(@NotNull Path object, @NotNull Path object2) {
        block13: {
            Object object3;
            Object object4;
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Intrinsics.checkNotNullParameter((Object)object2, (String)"");
            if (Java_ioKt.exists((Path)object)) {
                try {
                    object4 = object;
                    object3 = Java_ioKt.div((Path)object2, (String)"upgraded-From-Pre-v1.2.5.json");
                    object = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)object4, (Path)object3, Arrays.copyOf(object, ((CopyOption[])object).length)), (String)"");
                }
                catch (Throwable throwable) {}
            }
            object = Java_ioKt.div((Path)object2, (String)exampleFileName);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block13;
            InputStream inputStream = HintsManagerNG.class.getClassLoader().getResourceAsStream(exampleHintsResource);
            if (inputStream == null) break block13;
            object2 = inputStream;
            object4 = null;
            try {
                object3 = (InputStream)object2;
                try {
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"");
                    object = outputStream;
                    Throwable throwable = null;
                    try {
                        OutputStream outputStream2 = (OutputStream)object;
                        ByteStreamsKt.copyTo$default((InputStream)object3, (OutputStream)outputStream2, (int)0, (int)2, null);
                        outputStream2.close();
                    }
                    catch (Throwable throwable2) {
                        try {
                            object3 = throwable2;
                            throwable = throwable2;
                            throw object3;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            throw throwable3;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)object, null);
                    ((InputStream)object3).close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    object4 = throwable;
                    throw object;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)object2, null);
            return;
        }
    }

    private final Map getAllById(String object) {
        Map map;
        Map map2 = map = (Map)new LinkedHashMap();
        Map map3 = effectiveHints;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : map3.entrySet()) {
            HintClassData hintClassData = (HintClassData)entry.getValue();
            if (!Intrinsics.areEqual((Object)object, (Object)hintClassData.readId())) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
            if (!((HintClassData)entry.getValue()).hasInfo()) continue;
            object = ((HintClassData)entry.getValue()).copyOnlyChanged();
            map2.put(entry.getKey(), HintClassData.copy$default((HintClassData)entry.getValue(), false, false, false, (Map)object, null, false, false, false, 247, null));
        }
        return map;
    }

    public final void saveDirty(@NotNull HintClassData hintClassData, @NotNull HintClassData hintClassData2) {
        Intrinsics.checkNotNullParameter((Object)hintClassData, (String)"");
        Intrinsics.checkNotNullParameter((Object)hintClassData2, (String)"");
        if (Intrinsics.areEqual((Object)hintClassData.readId(), (Object)hintClassData2.readId())) {
            String string = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string2);
            this.saveFile(string, this.getAllById(string2));
        } else {
            String string = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string);
            String string3 = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string3);
            this.saveFile(string, this.getAllById(string3));
            String string4 = hintClassData2.readId();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = hintClassData2.readId();
            Intrinsics.checkNotNull((Object)string5);
            this.saveFile(string4, this.getAllById(string5));
        }
        this.reset();
        this.doInit(false);
    }

    private final void saveFile(String object, Map map) {
        String string = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        object = !StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null) ? (String)object + ".json" : object;
        Path path = externalHintsPath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            path = null;
        }
        object = Java_ioKt.div((Path)path, (String)object);
        Files.deleteIfExists((Path)object);
        if (!map.isEmpty()) {
            Json json = MiscKt.getJson();
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"");
            object = outputStream;
            Json json2 = json;
            json2.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)json2, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, HintClassData.Companion.serializer())), (Object)map, (OutputStream)object);
        }
    }

    private static final boolean doInit$lambda$2(Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile() && StringsKt.endsWith$default((String)((Object)path.getFileName()).toString(), (String)".json", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)exampleFileName);
    }

    private static final Unit doInit$lambda$6(boolean bl, Path object) {
        Intrinsics.checkNotNull((Object)object);
        String string = StringsKt.substringBeforeLast$default((String)PathsKt.getName((Path)((Object)object)), (String)".json", null, (int)2, null);
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream((Path)((Object)object), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"");
            for (Map.Entry entry : INSTANCE.processConfig(inputStream).entrySet()) {
                Map map = externalConfigs;
                Object k2 = entry.getKey();
                Object entry2 = entry.getValue();
                HintClassData hintClassData = (HintClassData)entry2;
                hintClassData.changeId(string);
                hintClassData.fillMissingHints();
                map.put(k2, entry2);
            }
        }
        catch (Throwable throwable) {
            MiscKt.logError(throwable, string, bl);
        }
        return Unit.INSTANCE;
    }

    private static final void doInit$lambda$7(Function1 function1, Object object) {
        function1.invoke(object);
    }

    static {
        externalConfigs = new LinkedHashMap();
        internalConfigs = new LinkedHashMap();
        effectiveHints = new LinkedHashMap();
    }
}

