/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.configurations;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import org.jetbrains.annotations.Nullable;

public class ConfigSettings {
    protected boolean clientSided = false;
    protected String category = "misc";
    protected LoadType loadType = LoadType.RELOAD;
    @Nullable
    protected Supplier<Boolean> condition = null;
    @Nullable
    protected Parent<?> parent = null;
    protected String[] aliases = new String[0];

    public ConfigSettings copy() {
        return new ConfigSettings().clientSide(this.clientSided).category(this.category).loadType(this.loadType).condition(this.condition).parent(this.parent).aliases(this.aliases);
    }

    public ConfigSettings clientSide(boolean value) {
        this.clientSided = value;
        return this;
    }

    public ConfigSettings clientSide() {
        return this.clientSide(true);
    }

    public ConfigSettings category(String category) {
        if (category == null) {
            throw new IllegalArgumentException("Category cannot be null.");
        }
        this.category = category;
        return this;
    }

    public ConfigSettings loadType(LoadType loadType) {
        if (loadType == null) {
            throw new IllegalArgumentException("Load Type cannot be null.");
        }
        this.loadType = loadType;
        return this;
    }

    public ConfigSettings condition(Supplier<Boolean> condition) {
        this.condition = condition;
        return this;
    }

    public ConfigSettings requiresMod(String modId) {
        return this.condition(() -> FabricLoader.getInstance().isModLoaded(modId));
    }

    public ConfigSettings parent(Parent<?> parent) {
        this.parent = parent;
        return this;
    }

    public <T> ConfigSettings parent(AbstractConfiguration<T> configuration, Predicate<T> predicate) {
        return this.parent(new Parent<T>(configuration, predicate));
    }

    public ConfigSettings aliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public record Parent<T>(Supplier<AbstractConfiguration<T>> configuration, Predicate<T> enabledPredicate) {
        public Parent(AbstractConfiguration<T> configuration, Predicate<T> enabledPredicate) {
            this(() -> configuration, enabledPredicate);
        }

        public Parent(AbstractConfiguration<T> configuration) {
            this(() -> configuration, (T object) -> true);
        }

        @Deprecated
        public Supplier<Boolean> createCondition() {
            return this::test;
        }

        public boolean test() {
            return this.test(this.configuration.get().getEffectiveValue());
        }

        public boolean test(Object parentValue) {
            try {
                return this.enabledPredicate.test(parentValue);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

