/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.configurations;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_2960;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigSettings;

public class BoundedIntegerConfiguration
extends AbstractConfiguration<Integer> {
    private final int minValue;
    private final int maxValue;

    public BoundedIntegerConfiguration(int defaultValue, int minValue, int maxValue, ConfigSettings settings) {
        super(BoundedIntegerConfiguration.validateDefaultValue(defaultValue, minValue, maxValue), settings);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    private static int validateDefaultValue(int defaultValue, int min, int max) {
        if (defaultValue > max || defaultValue < min) {
            throw new IllegalArgumentException("Integer Configurations cannot have a default value outside their bounds!");
        }
        return defaultValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Codec<Integer> getValueCodec() {
        return Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.comapFlatMap(this::parseString, Object::toString)).xmap(either -> {
            if (either.left().isPresent()) {
                return (Integer)either.left().get();
            }
            if (either.right().isPresent()) {
                return (Integer)either.right().get();
            }
            return null;
        }, Either::left);
    }

    private DataResult<Integer> parseString(String string) {
        try {
            return DataResult.success((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "'" + string + "' cannot be parsed. " + e.getMessage());
        }
    }

    @Override
    protected class_2960 getConfigTypeId() {
        return PneumonoCore.identifier("bounded_integer");
    }
}

